function vtb5_6(mu,beta,rmin,rmax)
%VTB5_6 Surface plot of the normalized amplitude of the primary
%  mass for a damped absorber design.
%  VTB5_6(mu,beta,rmin,rmax) displays the 3-D plot for normalized
%  amplitude for a given value of mu.  The function is plotted
%  between the normalized frequencies rmin and rmax, with the
%  damping ratio ranging from 0 to 1.
%  Use view([-1 0 0]) to view amplitude versus zeta, and
%  view([0 -1 0]) to view amplitude versus r.

r=rmin:(rmax-rmin)/20:rmax;

z=.05:.025:1;

[r,z]=meshdom(r,z);

num=4*(r.*z).^2+(r.^2-beta^2).^2;
den1=4*(r.*z).^2 .*(r.^2+mu*r.^2-1).^2;
den2=(mu.*r.^2.*beta^2-(r.^2-1).*(r.^2-beta^2)).^2;
f=sqrt(num./(den1+den2));  %equation 5.42


aa=version;ll=length(aa);

surf(r,z,f)

xlabel('normalized frequency - r')
ylabel('damping ratio - zeta')
zlabel('normalized magnitude')

set(gcf,'Units','default')
title('Normalized magnitude of the primary mass')

%azi_con=uicontrol(gcf,...
%    'style','edit',...
%	'position',[25 25 20 20],...
%	'string','30',...
%	'min',-90,'max',90,'value',30,...
%	'callback',[...
%	'set(azm_cur,''string'',',...
%	     'num2str(get(axm_con,''val''))),',...
%    'set(gca,''view'',',...
%	'[get(sli_azm,''val''),get(sli_elv,''val'')])']);
set(gca,'view',[30 30])
global sli_azm
sli_azm=uicontrol(gcf,...
    'style','slider',...
	'position',[.25 0 .5 .025],...
	'units','normalized',...
	'min',90,'max',-90,'value',30,...
	'callback',[...
    'global sli_elv,',...
    'global sli_azm,',...
    'set(gca,''view'',',...
	'[get(sli_azm,''val''),get(sli_elv,''val'')])']);
global sli_azm
global sli_elv
sli_elv=uicontrol(gcf,...
    'style','slider',...
	'position',[.0 .25 .0185 .5],...
	'units','normalized',...
	'min',-90*0,'max',90,'value',30,...
	'callback',[...
    'global sli_elv,',...
    'global sli_azm,',...
    'set(gca,''view'',',...
	'[get(sli_azm,''val''),get(sli_elv,''val'')])']);
global sli_elv

%	'set(azm_cur,''string'',',...
%	     'num2str(get(sli_azm,''val''))),',...
%global axm_cur
%azm_cur=uicontrol(gcf,...
%    'style','text',...
%	'pos',[120 80 50 20],...
%	'string',num2str(get(sli_azm,'value')),...
%	'callback');
